#include <TFT_eSPI.h>
#include <CST816S.h>
#include "Free_Fonts.h"
#include <Wire.h>

TFT_eSPI tft = TFT_eSPI();
CST816S touch(5, 6, 10, 7);

void setup() {
  Serial.begin(115200);

  pinMode(TFT_BL, OUTPUT);
  digitalWrite(TFT_BL, HIGH);

  tft.begin();
  tft.fillScreen(TFT_BLACK);
  tft.setTextColor(TFT_WHITE, TFT_BLACK);
  tft.setFreeFont(FSB9);

  drawMiddleText();
  drawButtons();
  touch.begin();
}

void drawMiddleText() {
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.print("Calling 7061350809");
}

void drawButtons() {
  int buttonRadius = 30;

  // Draw Call Button
  int callButtonX = 80;
  int callButtonY = 180; // Moved up
  tft.fillCircle(callButtonX, callButtonY, buttonRadius, TFT_GREEN);
  tft.setTextColor(TFT_WHITE, TFT_GREEN);
  tft.setCursor(callButtonX - 15, callButtonY - 7); // Center text inside the circle
  tft.print("Call");

  // Draw End Button
  int endButtonX = 160;
  int endButtonY = 180; // Moved up
  tft.fillCircle(endButtonX, endButtonY, buttonRadius, TFT_RED);
  tft.setTextColor(TFT_WHITE, TFT_RED);
  tft.setCursor(endButtonX - 15, endButtonY - 7); // Center text inside the circle
  tft.print("End");
}

void loop() {
  if (touch.available()) {
    int x = touch.data.x;
    int y = touch.data.y;
    if (isCallButtonTouched(x, y)) {
      // Handle Call button press
      Serial.println("Call button pressed");
    }
    if (isEndButtonTouched(x, y)) {
      // Handle End button press
      Serial.println("End button pressed");
    }
  }
}

bool isCallButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = 80;
  int buttonY = 180; // Same as callButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
}

bool isEndButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = 160;
  int buttonY = 180; // Same as endButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
}
